/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.system;

import com.ibm.hsc.ccfw.pa.system.PIBpa;
import com.ibm.hsc.ccfw.pa.system.PIBpcFsp;
import com.ibm.hsc.ccfw.pa.system.PICecFsp;
import com.ibm.hsc.ccfw.pa.system.PIMachineSystem;
import com.ibm.hsc.ccfw.pa.util.PAHscEventHandler;
import com.ibm.hsc.ccfw.pa.util.PAHscEventListener;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hwmca.fw.system.Manager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.xml.ClassConfigData;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystemProvider;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.snia.wbem.cim.CIMInstance;

public class PIMachineSystemProvider
extends RemoteMachineSystemProvider
implements PAHscEventListener {
    private static final String TRACE_MASKT = "PPAPMSPT";
    private static final String TRACE_MASKF = "PPAPMSPF";
    private static final String TRACE_MASKD = "PPAPMSPD";
    private static PIMachineSystemProvider pimsp = null;
    private PAHscEventHandler heHandler = null;
    private static final String KEY_CIM_RETRY = "RetryTime";
    private static final int RETRY_TIME_DEFAULT = 300;
    private int retryTime;
    private Map commMap = new HashMap();
    private static boolean getTrackedCalled = false;

    public PIMachineSystemProvider(ClassConfigData classConfigData) {
        super(classConfigData);
        pimsp = this;
    }

    public static PIMachineSystemProvider getPIMachineSystemProvider() {
        return pimsp;
    }

    protected void initializeTrackedSystems() {
        Trace.trace((String)TRACE_MASKD, (Object)"--> initializeTrackedSystems");
        try {
            this.retryTime = new Integer((String)this.ccData.getConfigData().get(KEY_CIM_RETRY));
        }
        catch (Exception exception) {
            this.retryTime = 300;
            Trace.trace((String)TRACE_MASKT, (Object)("error parsing key (RetryTime).  Default CIM retry (" + this.retryTime + ")."));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
        }
        Trace.trace((String)TRACE_MASKD, (Object)"need to block until PTower is up...");
        Manager.getManager().waitForTowers();
        Trace.trace((String)TRACE_MASKD, (Object)"...PTower is up - finish initialization");
        this.heHandler = PAHscEventHandler.buildHandler(this, this.ccData.getConfigData());
        String string = new PIBpa().getCIMClass();
        this.heHandler.addSubscription(1, string);
        this.heHandler.addSubscription(2, string);
        this.heHandler.addSubscription(4, string);
        string = new PIBpcFsp().getCIMClass();
        this.heHandler.addSubscription(1, string);
        this.heHandler.addSubscription(2, string);
        this.heHandler.addSubscription(4, string);
        string = new PICecFsp().getCIMClass();
        this.heHandler.addSubscription(1, string);
        this.heHandler.addSubscription(2, string);
        this.heHandler.addSubscription(4, string);
        Trace.trace((String)TRACE_MASKD, (Object)"get systems...");
        PIMachineSystem pIMachineSystem = null;
        int n = 0;
        Enumeration enumeration = null;
        HashSet<PIMachineSystem> hashSet = new HashSet<PIMachineSystem>();
        try {
            n = 0;
            enumeration = PIBpa.getLiveSystems(this.retryTime);
            while (enumeration.hasMoreElements()) {
                pIMachineSystem = (PIMachineSystem)((Object)enumeration.nextElement());
                this.addRemoteSystem(pIMachineSystem.getUniqueCIMKey(), (RemoteSystem)pIMachineSystem);
                hashSet.add(pIMachineSystem);
                ++n;
            }
            Trace.trace((String)TRACE_MASKF, (Object)("PIBpa count=" + n));
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception caught getting PIBpa's");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
        }
        try {
            n = 0;
            enumeration = PIBpcFsp.getLiveSystems(this.retryTime);
            while (enumeration.hasMoreElements()) {
                pIMachineSystem = (PIMachineSystem)((Object)enumeration.nextElement());
                this.addRemoteSystem(pIMachineSystem.getUniqueCIMKey(), (RemoteSystem)pIMachineSystem);
                ((PIBpcFsp)pIMachineSystem).associateEncapsulatingBpa(hashSet);
                ++n;
            }
            Trace.trace((String)TRACE_MASKF, (Object)("PIBpcFsp count=" + n));
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception caught getting PIBpcFsp's");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
        }
        try {
            n = 0;
            enumeration = PICecFsp.getLiveSystems(this.retryTime);
            while (enumeration.hasMoreElements()) {
                pIMachineSystem = (PIMachineSystem)((Object)enumeration.nextElement());
                this.addRemoteSystem(pIMachineSystem.getUniqueCIMKey(), (RemoteSystem)pIMachineSystem);
                ++n;
            }
            Trace.trace((String)TRACE_MASKF, (Object)("PICecFsp count=" + n));
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception caught getting PICecFsp's");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
        }
        Trace.trace((String)TRACE_MASKD, (Object)"<-- initializeTrackedSystems");
    }

    public Set getTrackedSystems() {
        if (!getTrackedCalled) {
            getTrackedCalled = true;
            RemoteSystemManager remoteSystemManager = RemoteSystemManager.getRemoteSystemManager();
            PIBpa pIBpa = new PIBpa();
            Set set = remoteSystemManager.getKnownSystems(((Object)((Object)pIBpa)).getClass());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                pIBpa = (PIBpa)((Object)iterator.next());
                pIBpa.associateEncapsulatedBpcs();
            }
            PIBpcFsp pIBpcFsp = new PIBpcFsp();
            Set set2 = remoteSystemManager.getKnownSystems(((Object)((Object)pIBpcFsp)).getClass());
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                pIBpcFsp = (PIBpcFsp)((Object)iterator2.next());
                pIBpcFsp.associateEncapsulatingBpa();
            }
        }
        return super.getTrackedSystems();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hscEventOccured(HSCEvent hSCEvent) {
        block13: {
            if (!this.providerInitialized) {
                return;
            }
            Trace.trace((String)TRACE_MASKF, (Object)"--> hscEventOccured");
            Trace.trace((String)TRACE_MASKF, (Object)("object type: " + hSCEvent.getObjectType()));
            Trace.trace((String)TRACE_MASKF, (Object)("event type: " + hSCEvent.getEventType()));
            try {
                PIMachineSystem pIMachineSystem = null;
                CIMInstance cIMInstance = (CIMInstance)hSCEvent.getNewObject();
                if (cIMInstance.getClassName().equals("IBMHSC_Frame")) {
                    pIMachineSystem = new PIBpa(cIMInstance, true);
                } else if (cIMInstance.getClassName().equals("IBMHSC_Connection")) {
                    String string = (String)PIHscUtil.getCIMAttribute(cIMInstance, "LocationCode").getValue();
                    if (!string.equals("SIDE_A") && !string.equals("SIDE_B")) {
                        Trace.trace((String)TRACE_MASKF, (Object)("<-- hscEventOccured: Ignoring non-BPC IBMHSC_Connection (LocationCode=" + string + ")"));
                        return;
                    }
                    pIMachineSystem = new PIBpcFsp(cIMInstance, true);
                } else {
                    if (!cIMInstance.getClassName().equals("IBMHSC_ComputerSystem")) {
                        Trace.trace((String)TRACE_MASKF, (Object)("<-- hscEventOccured: Ignoring unknown CIMInstance type: " + cIMInstance.getClassName()));
                        return;
                    }
                    pIMachineSystem = new PICecFsp(cIMInstance, true);
                }
                Trace.trace((String)TRACE_MASKF, (Object)("instance key: " + pIMachineSystem.getUniqueCIMKey()));
                if (pIMachineSystem.isDummy()) {
                    Trace.trace((String)TRACE_MASKF, (Object)"<-- hscEventOccured: Ignoring dummy system");
                    return;
                }
                int n = hSCEvent.getEventType();
                if (n == 1) {
                    Trace.trace((String)TRACE_MASKD, (Object)"adding it");
                    pIMachineSystem.setCIMRetryTime(this.retryTime);
                    this.addRemoteSystem(pIMachineSystem.getUniqueCIMKey(), (RemoteSystem)pIMachineSystem, true);
                    break block13;
                }
                if (n == 4) {
                    Trace.trace((String)TRACE_MASKD, (Object)"changing it");
                    this.changeRemoteSystem(pIMachineSystem.getUniqueCIMKey(), (RemoteSystem)pIMachineSystem, true);
                    break block13;
                }
                if (n != 2) break block13;
                Trace.trace((String)TRACE_MASKD, (Object)"removing it");
                this.removeRemoteSystem(pIMachineSystem.getUniqueCIMKey(), true);
                if (pIMachineSystem instanceof PIBpcFsp) {
                    ((PIBpcFsp)pIMachineSystem).disassociateEncapsulatingBpa();
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)"Exception caught during event handling");
                Trace.trace((String)TRACE_MASKT, (Object)exception);
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)"<-- hscEventOccured");
    }
}

